from typing import Any, Tuple
from pipelines.prompta.oracle.base_llm_oracle import BaseLLMOracle
from pipelines.prompta.utils import get_value_by_key


class BaselineLLMOracle(BaseLLMOracle):
    
    def _get_membership_query_result(self, input_str: Tuple[str], use_cache: bool=True, seed: int=0, *args: Any, **kwds: Any) -> Any:
        if input_str in self.llm_resp_cache and use_cache:
            ans = self.llm_resp_cache[input_str]['answer']
            return ans
        queries = self._construct_existence_message(input_str)
        result = self._get_json_resp(queries, seed=seed)
        ans = get_value_by_key(result, "answer", is_boolean=True)
        self.llm_resp_cache[input_str] = {'answer': ans}
        return ans
    
    def _construct_existence_message(self, query: str):
        return [
            {"role": "system", "content": f"You are a helpful assistant designed to output JSON. Answer in a consistent style. Like {str({'answer': True})}"},
            {"role": "user", "content": f"{self.language.definition}. Given a string \"{query}\", does this string belongs to the language?"}
        ]

